VERSION 5.00
Begin VB.Form frmEZScan_VC 
   Caption         =   "Form1"
   ClientHeight    =   3600
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   3600
   ScaleWidth      =   5250
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtReadings 
      Height          =   3135
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   1
      Text            =   "frmEZScan_VC.frx":0000
      Top             =   240
      Width           =   2175
   End
   Begin VB.CommandButton cmdScan 
      Caption         =   "Start Scan"
      Height          =   855
      Left            =   2640
      TabIndex        =   0
      Top             =   240
      Width           =   2295
   End
End
Attribute VB_Name = "frmEZScan_VC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
''    Copyright  2002 Agilent Technologies Inc. All rights
''    reserved.
''
'' You have a royalty-free right to use, modify, reproduce and distribute
'' the Sample Application Files (and/or any modified version) in any way
'' you find useful, provided that you agree that Agilent has no
'' warranty,  obligations or liability for any Sample Application Files.
''
'' Agilent Technologies provides programming examples for illustration only,
'' This sample program assumes that you are familiar with the programming
'' language being demonstrated and the tools used to create and debug
'' procedures. Agilent support engineers can help explain the
'' functionality of Agilent software components and associated
'' commands, but they will not modify these samples to provide added
'' functionality or construct procedures to meet your specific needs.
'' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'
' This code implements a simple scan with the 34970A using the VISA COM objects
' that are part of the Agilent IO libraries.
'
' This code has a reference to the Agilent VISA COM objects. To use the IO object in
' another Visual Basic project set the reference in the Project/References menu
'
' Include the following libraries in Project->References:
' The VISA COM 1.0 Type Library, which corresponds to the VISACOM.tlb file,
' "Agilent VISA COM Resource Manager 1.0", which corresponds to the AgtRM.DLL file,
' and "VISA COM 488.2 Formatted I/O 1.0", which corresponds to the
' BasicFormattedIO.dll file.
'
' Then simply use a statement such as
' Dim DAQ As VisaComLib.FormattedIO488 to create the formatted I/O reference '
' and use Set DAQ = new BASICFORMATTEDIOLib.FmtdIOCls to create the actual object.
' See the sample below for initializing the IO
'

Private Sub cmdScan_Click()
    ' initialize io object set the functions and then scan
    Dim readings As Variant
    Dim result As String
    Dim i As Long
    
    Dim io_mgr As VisaComLib.ResourceManager
    Dim DAQ As VisaComLib.FormattedIO488
    Dim session As VisaComLib.IMessage
    

    Set io_mgr = New AgilentRMLib.SRMCls
    Set DAQ = New BASICFORMATTEDIOLib.FmtdIOCls
    Set session = io_mgr.Open("GPIB0::9")
    Set DAQ.IO = session
    
    With DAQ
        ' clear if it is waiting for trigger
        .IO.Clear
        
        ' end any scan
        .WriteString "Abort"
        
        ' reset instrument
        .WriteString "*RST"

        ' configure for DC and Resistance
        .WriteString "Conf:volt:DC Auto,(@101,102);:Volt:DC:NPLC 0.02,(@101,102)"
        .WriteString "Conf:Res Auto,(@106:108);:Res:NPLC 0.02,(@106:108)"
        
        ' Set the scan list
        .WriteString "Route:Scan (@101,102,106:108)"

        ' initialize and wait for the scan to complete
        .WriteString "INIT"
        .WriteString "*OPC?"
        result = .ReadString

        ' Get the data from the instrument
        .WriteString "Fetch?"
        readings = .ReadList
    End With
    
    With txtReadings
        .Text = ""
        .SelText = Now & vbCrLf
        For i = 0 To UBound(readings)
            .SelText = readings(i) & vbCrLf
        Next i
    End With

End Sub

